/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   MPC5XX Processor Header File
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5XX
::   Limitations :   None
::   $Workfile: MPC5XX.h $
::
::-----------------------------------------------------------------------------------------------------------
::
::   Microprocessor Definition
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __MPC5XX_H
#define __MPC5XX_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/

/*----- DEFINES -------------------------------------------------------------------------------------------*/

#ifndef __BigEndian
  #error Big Endian must be defined
#endif

/* Supported processors */
#define MPC555_TARGET 1
#define MPC565_TARGET 2 
#define MPC563_TARGET 3 

/* Catch unsupported processors */
#ifndef __TARGET_PROCESSOR
    #error TARGET_PROCESSOR is undefined. Define as MPC555_TARGET, MPC563_TARGET or MPC565_TARGET
#endif

#if ((__TARGET_PROCESSOR != MPC555_TARGET) && (__TARGET_PROCESSOR != MPC563_TARGET)&& (__TARGET_PROCESSOR != MPC565_TARGET))
    #error Unsupported TARGET_PROCESSOR definition
#endif

#endif /* __MPC5XX_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/

